//
//  MCReportMergeTokenProcessor.h
//  MCReporting
//
//  Created by Alykhan Jetha on 20/12/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <MCApplication/MCMergeTokenKeyPathProcessor.h>


typedef enum _MCRMTokenProcessingType {
	MCRMTokenProcessingKeyPathType     = 0,
	MCRMTokenProcessingSUMType     	   = 1,
	MCRMTokenProcessingAVGType         = 2,
	MCRMTokenProcessingMINType         = 3,
	MCRMTokenProcessingMAXType         = 4,
	MCRMTokenProcessingCOUNTType       = 5,
	MCRMTokenProcessingSubMergeType    = 6,
	MCRMTokenProcessingFScriptType     = 7
} MCRMTokenProcessingType;


@interface MCReportMergeTokenProcessor : MCMergeTokenKeyPathProcessor {

	MCRMTokenProcessingType processingType;
	NSAttributedString *instruction;
	
}

- (MCRMTokenProcessingType)processingType;
- (void)setProcessingType:(MCRMTokenProcessingType)aProcessingType;

- (BOOL)shouldEnableInstructionField;

- (NSAttributedString *)instruction;
- (void)setInstruction:(NSAttributedString *)anInstruction;

- (BOOL)hasScript;

@end
